/*
 * BrowserSample.java
 *
 * Created on 2007/11/26, 11:07
 */

package io;

import java.io.IOException;
import java.net.URL;
import javax.swing.event.HyperlinkEvent.EventType;

/**
 *
 * @author  naoki
 */
public class BrowserSample extends javax.swing.JFrame {
    
    /** Creates new form BrowserSample */
    public BrowserSample() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        txtUrl = new javax.swing.JTextField();
        btnOpen = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        epBrowser = new javax.swing.JEditorPane();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        btnOpen.setText("開く");
        btnOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnOpenActionPerformed(evt);
            }
        });

        epBrowser.setEditable(false);
        epBrowser.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
                epBrowserHyperlinkUpdate(evt);
            }
        });
        jScrollPane1.setViewportView(epBrowser);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 388, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(txtUrl, javax.swing.GroupLayout.DEFAULT_SIZE, 330, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnOpen)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnOpen)
                    .addComponent(txtUrl, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 253, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

        /** リンクがクリックされたときの処理 */
    private void epBrowserHyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {//GEN-FIRST:event_epBrowserHyperlinkUpdate
        if(evt.getEventType() != EventType.ACTIVATED) return;
        URL url = evt.getURL();
        String openUrl = url.toString();
        txtUrl.setText(openUrl);
        try{
            epBrowser.setPage(url);
        } catch(IOException e){
            epBrowser.setText("error:" + e.toString());
        }
    }//GEN-LAST:event_epBrowserHyperlinkUpdate

        /** URLが指定されたときの処理 */
    private void btnOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnOpenActionPerformed
        String openUrl = txtUrl.getText();
        try{
            epBrowser.setPage(openUrl);
        } catch(IOException e){
            epBrowser.setText("error:" + e.toString());
        }
    }//GEN-LAST:event_btnOpenActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new BrowserSample().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnOpen;
    private javax.swing.JEditorPane epBrowser;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextField txtUrl;
    // End of variables declaration//GEN-END:variables
    
}
