/*
 * SwitchSample.java
 *
 * Created on 2007/11/24, 16:22
 */

package flow;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

/**
 *
 * @author  naoki
 */
public class SwitchSample extends javax.swing.JFrame {
    enum Figure{
        BATSU("バツ"){
            @Override
            void draw(Graphics g) {
                g.drawLine(0, 0, 49, 49);
                g.drawLine(0, 49, 49, 0);
            }
        },
        TRIANGLE("三角"){
            @Override
            void draw(Graphics g){
                g.setColor(Color.GREEN);
                g.fillPolygon(
                        new int[]{0, 25, 49},
                        new int[]{49, 0, 49},
                        3);
            }
        },
        RECTANGLE("四角"){
            @Override
            void draw(Graphics g) {
                g.setColor(Color.RED);
                g.fillRect(0, 0, 49, 49);
            }
        },
        CIRCLE("丸"){
            @Override
            void draw(Graphics g) {
                g.setColor(Color.BLUE);
                g.fillOval(8, 8, 35, 35);
            }
        },
        DOUBLE_CIRCLE("二重丸"){
            @Override
            void draw(Graphics g) {
                g.setColor(Color.MAGENTA);
                g.fillOval(0, 0, 49, 49);
                CIRCLE.draw(g);
            }
        };

        private String name;
        Figure(String name){
            this.name = name;
        }

        abstract void draw(Graphics g);

        @Override
        public String toString() {
            return name;
        }
    }
    
    /** Creates new form SwitchSample */
    public SwitchSample() {
        initComponents();
        
        Figure[] items = Figure.values();
        ComboBoxModel model = new DefaultComboBoxModel(items);
        cbShape.setModel(model);        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        cbShape = new javax.swing.JComboBox();
        btnShow = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        tpOutput = new javax.swing.JTextPane();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        cbShape.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "バツ", "四角", "丸", "二重丸" }));

        btnShow.setText("表示");
        btnShow.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnShowActionPerformed(evt);
            }
        });

        jScrollPane1.setViewportView(tpOutput);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(89, 89, 89)
                        .addComponent(cbShape, javax.swing.GroupLayout.PREFERRED_SIZE, 121, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnShow))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cbShape, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnShow))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 253, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void btnShowActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnShowActionPerformed
        //選択肢を取得
        Figure selected = (Figure)cbShape.getSelectedItem();
        //画像を生成
        Image img = createImage(50, 50);
        Graphics g = img.getGraphics();
        selected.draw(g);
        ImageIcon ii = new ImageIcon(img);

        //JTextPaneに表示
        try {
            StyledDocument doc = tpOutput.getStyledDocument();
            //図形の名前の出力
            String str = cbShape.getSelectedItem().toString();
            doc.insertString(doc.getLength(), str + "\n", null);
            //図形の出力
            SimpleAttributeSet attr = new SimpleAttributeSet();
            StyleConstants.setIcon(attr, ii);
            doc.insertString(doc.getLength(), str + "\n", attr);
        } catch (BadLocationException ex) {
            ex.printStackTrace();
        }
}//GEN-LAST:event_btnShowActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new SwitchSample().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnShow;
    private javax.swing.JComboBox cbShape;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextPane tpOutput;
    // End of variables declaration//GEN-END:variables
    
}
