/*
 * IfSample.java
 *
 * Created on 2007/11/24, 15:00
 */

package flow;

import java.awt.Color;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

/**
 *
 * @author  naoki
 */
public class IfSample extends javax.swing.JFrame {
    
    /** Creates new form IfSample */
    public IfSample() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        txtInput = new javax.swing.JTextField();
        btnJudge = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        tpOutput = new javax.swing.JTextPane();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        btnJudge.setText("判定");
        btnJudge.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnJudgeActionPerformed(evt);
            }
        });

        jScrollPane1.setViewportView(tpOutput);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(txtInput, javax.swing.GroupLayout.DEFAULT_SIZE, 312, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnJudge)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnJudge)
                    .addComponent(txtInput, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 253, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void btnJudgeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnJudgeActionPerformed
        //入力の取得
        String str = txtInput.getText();

        //表示文字列の作成
        SimpleAttributeSet attr = new SimpleAttributeSet();
        String message = "入力は「" + str + "」";
        int len = str.length();
        if (len == 0) {
            //入力がなかった場合
            message += "ありません";
            StyleConstants.setForeground(attr, Color.RED);
            StyleConstants.setItalic(attr, true);
        } else if("good".equals(str)){
            message += "いいってことよ";
            StyleConstants.setFontSize(attr, 20);
        } else if(len < 5){
            message += "短い";
            StyleConstants.setFontSize(attr, 10);
        }else{
            message += "でした";
        }

        //出力
        StyledDocument doc = tpOutput.getStyledDocument();
        try {
            doc.insertString(doc.getLength(), message + "\n", attr);
        } catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }//GEN-LAST:event_btnJudgeActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new IfSample().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnJudge;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextPane tpOutput;
    private javax.swing.JTextField txtInput;
    // End of variables declaration//GEN-END:variables
    
}
