package jpa.study.entity;

import static org.junit.Assert.assertEquals;

import javax.persistence.EntityManager;

import org.junit.runner.RunWith;
import org.seasar.framework.unit.Seasar2;
import org.seasar.framework.unit.annotation.TxBehavior;
import org.seasar.framework.unit.annotation.TxBehaviorType;

/**
 * リスト7.2_1 永続コンテキストの振る舞いを確かめるためのテストクラス
 */
@RunWith(Seasar2.class)
@TxBehavior(TxBehaviorType.COMMIT)
public class PersistenceContextTest {

	EntityManager em;

	/**
	 * リスト7.2_2 永続コンテキストによるキャッシュを確かめるテストコード
	 * 
	 * @throws Exception
	 */
	public void findTwice() throws Exception {
		Emp emp1 = em.find(Emp.class, 1L);
		Emp emp2 = em.find(Emp.class, 1L);
		assertEquals(emp1, emp2);
	}

	/**
	 * リスト7.2_4 トランザクションがコミットされる場合のテストコード
	 * 
	 * @throws Exception
	 */
	public void synchronization_commit() throws Exception {
		Emp emp1 = em.find(Emp.class, 1L);
		emp1.setEmpName("hoge");
		Emp emp2 = em.find(Emp.class, 2L);
		em.remove(emp2);
		System.out.println("#コミットの前");
	}

	/**
	 * リスト7.2_6 トランザクションがロールバックされる場合のテストコード
	 * 
	 * @throws Exception
	 */
	@TxBehavior(TxBehaviorType.ROLLBACK)
	public void synchronization_rollback() throws Exception {
		Emp emp1 = em.find(Emp.class, 1L);
		emp1.setEmpName("hoge");
		Emp emp2 = em.find(Emp.class, 2L);
		em.remove(emp2);
		System.out.println("#ロールバックの前");
	}

	/**
	 * リスト7.2_8 問い合わせが行われる場合のテストコード
	 * 
	 * @throws Exception
	 */
	public void synchronization_jpql() throws Exception {
		Emp emp1 = em.find(Emp.class, 1L);
		emp1.setEmpName("hoge");
		Emp emp2 = em.find(Emp.class, 2L);
		em.remove(emp2);
		System.out.println("#JPQL実行前");
		em.createQuery("select e from Emp e").getResultList();
		System.out.println("#JPQL実行後");
	}

	/**
	 * リスト7.2_10 flushメソッドが実行される場合のテストコード
	 * 
	 * @throws Exception
	 */
	public void synchronization_flush() throws Exception {
		Emp emp1 = em.find(Emp.class, 1L);
		emp1.setEmpName("hoge");
		Emp emp2 = em.find(Emp.class, 2L);
		em.remove(emp2);
		System.out.println("#flush()の前");
		em.flush();
		System.out.println("#flush()の後");
	}
}
