package jpa.study.entity;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import org.junit.runner.RunWith;
import org.seasar.framework.unit.Seasar2;
import org.seasar.framework.unit.annotation.TxBehavior;
import org.seasar.framework.unit.annotation.TxBehaviorType;

/**
 * リスト3.2_6 EntityManagerの基本操作を確かめるためのテストクラス
 */
@RunWith(Seasar2.class)
@TxBehavior(TxBehaviorType.COMMIT)
public class EntityManagerTest {

	EntityManager em;

	/**
	 * リスト3.3_1 主キーによるエンティティの取得
	 * 
	 * @throws Exception
	 */
	public void findById() throws Exception {
		Emp emp = em.find(Emp.class, 1L);
		assertEquals(new Long(1), emp.getId());
		assertEquals(new Integer(7369), emp.getEmpNo());
		assertEquals("SMITH", emp.getEmpName());
	}

	/**
	 * リスト3.3_3 主キーによるエンティティの取得（エンティティが存在しない場合）
	 * 
	 * @throws Exception
	 */
	public void findById_null() throws Exception {
		Emp emp = em.find(Emp.class, 99L);
		assertNull(emp);
	}

	/**
	 * リスト3.3_4 JPQLを利用したエンティティの取得
	 * 
	 * @throws Exception
	 */
	public void findWithJpql() throws Exception {
		String jpql = "select e from Emp e where e.empName like 'S%' order by e.empName";

		Query query = em.createQuery(jpql);
		@SuppressWarnings("unchecked")
		List<Emp> list = query.getResultList();
		assertEquals(2, list.size());
		Emp emp = list.get(0);
		assertEquals("SCOTT", emp.getEmpName());
		emp = list.get(1);
		assertEquals("SMITH", emp.getEmpName());
	}

	/**
	 * リスト3.4_1 エンティティの更新
	 * 
	 * @throws Exception
	 */
	public void update() throws Exception {
		Emp emp = em.find(Emp.class, 1L);
		emp.setEmpName("HOGE");
	}

	/**
	 * リスト3.5_1 エンティティの追加
	 * 
	 * @throws Exception
	 */
	public void persist() throws Exception {
		Emp emp = new Emp();
		emp.setEmpNo(8000);
		emp.setEmpName("FOO");
		em.persist(emp);
		assertNotNull(emp.getId());
		assertNotNull(emp.getVersionNo());
	}

	/**
	 * リスト3.6_1 エンティティの削除
	 * 
	 * @throws Exception
	 */
	public void remove() throws Exception {
		Emp emp = em.find(Emp.class, 1L);
		em.remove(emp);
	}

}
