package jpa.study.entity;

import java.util.List;

import javax.persistence.EntityManager;

import org.junit.runner.RunWith;
import org.seasar.framework.unit.Seasar2;
import org.seasar.framework.unit.annotation.TxBehavior;
import org.seasar.framework.unit.annotation.TxBehaviorType;

/**
 * リスト4.4_13 AssociationTestクラス
 */
@RunWith(Seasar2.class)
@TxBehavior(TxBehaviorType.COMMIT)
public class AssociationTest {

	EntityManager em;

	/**
	 * リスト4.4_14 many-to-one/one-to-many関連のナビゲーション
	 * 
	 * @throws Exception
	 */
	public void navigate_manyToOne_oneToMany() throws Exception {
		System.out.println("# 1 #");
		Employee employee = em.find(Employee.class, 1);
		System.out.println("# 2 #");

		System.out.println("# 3 #");
		System.out.println(employee.getName());
		System.out.println("# 4 #");

		System.out.println("# 5 #");
		Department department = employee.getDepartment();
		System.out.println("# 6 #");

		System.out.println("# 7 #");
		System.out.println(department.getName());
		System.out.println("# 8 #");

		System.out.println("# 9 #");
		List<Employee> employees = department.getEmployees();
		System.out.println("# 10 #");

		System.out.println("# 11 #");
		for (Employee e : employees) {
			System.out.println(e.getName());
		}
		System.out.println("# 12 #");
	}

	/**
	 * リスト4.4_17 one-to-one関連のナビゲーション
	 * 
	 * @throws Exception
	 */
	public void navigate_oneToOne() throws Exception {
		System.out.println("# 1 #");
		Employee employee = em.find(Employee.class, 1);
		System.out.println("# 2 #");

		System.out.println("# 3 #");
		System.out.println(employee.getName());
		System.out.println("# 4 #");

		System.out.println("# 5 #");
		Address address = employee.getAddress();
		System.out.println("# 6 #");

		System.out.println("# 7 #");
		System.out.println(address.getStreet());
		System.out.println("# 8 #");

		System.out.println("# 9 #");
		Employee employee2 = address.getEmployee();
		System.out.println("# 10 #");

		System.out.println("# 11 #");
		System.out.println(employee2.getName());
		System.out.println("# 12 #");
	}

	/**
	 * リスト4.4_19 関連を意識したエンティティの追加
	 * 
	 * @throws Exception
	 */
	public void persist() throws Exception {
		Department department = em.find(Department.class, 3);

		Address address = new Address();
		address.setStreet("E STREET");
		address.setCity("TOKYO");

		Employee employee = new Employee();
		employee.setName("HOGE");
		employee.setAge(30);
		employee.setDepartment(department);
		employee.setAddress(address);

		address.setEmployee(employee);
		department.getEmployees().add(employee);

		em.persist(address);
		em.persist(employee);
	}

}
