package jpa.study.dao;

import static org.junit.Assert.assertEquals;

import java.math.BigDecimal;
import java.util.List;

import jpa.study.entity.Emp;

import org.junit.runner.RunWith;
import org.seasar.framework.unit.Seasar2;
import org.seasar.framework.unit.annotation.TxBehavior;
import org.seasar.framework.unit.annotation.TxBehaviorType;

/**
 * リスト9.3_1 EmpDaoTestの作成
 */
@RunWith(Seasar2.class)
@TxBehavior(TxBehaviorType.COMMIT)
public class EmpDaoTest {

	EmpDao dao;

	/**
	 * リスト9.3_3 findByExamplメソッドの実行（salフィールドだけを検索条件に指定）
	 * 
	 * @throws Exception
	 */
	public void findByExample_sal() throws Exception {
		Emp emp = new Emp();
		emp.setSal(new BigDecimal(3000));
		List<Emp> list = dao.findByExample(emp);
		assertEquals(2, list.size());
	}

	/**
	 * リスト9.3_5 findByExamplメソッドの実行（salとempNameフィールドを検索条件に指定）
	 * 
	 * @throws Exception
	 */
	public void findByExample_sal_empName() throws Exception {
		Emp emp = new Emp();
		emp.setSal(new BigDecimal(3000));
		emp.setEmpName("SCOTT");
		List<Emp> list = dao.findByExample(emp);
		assertEquals(1, list.size());
		assertEquals("SCOTT", list.get(0).getEmpName());
	}
}
