package jpa.study.entity;

import java.util.List;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Version;

/**
 * リスト4.4_11 Departmentクラス
 * 
 * リスト6.2_3 Departmentクラス
 */
@Entity
public class Department {

	@Id
	@GeneratedValue
	private Integer id;

	private String name;

	private String location;

	@OneToMany(mappedBy = "department")
	private List<Employee> employees;

	@Version
	private Integer version;

	public List<Employee> getEmployees() {
		return employees;
	}

	public void setEmployees(List<Employee> employees) {
		this.employees = employees;
	}

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getLocation() {
		return location;
	}

	public void setLocation(String location) {
		this.location = location;
	}

	public Integer getVersion() {
		return version;
	}

	public void setVersion(Integer version) {
		this.version = version;
	}

}
