package jpa.study.dao;

import java.util.List;

import jpa.study.entity.Emp;

public interface EmpDao {

	public List<Emp> findAll();

	public Emp find(Long id);

	public Emp find(Long id, Integer versionNo);

	public void persist(Emp emp);

	public Emp mergee(Emp emp);

	public void remove(Emp emp);

	public boolean contains(Emp emp);

	public void refresh(Emp emp);

	public void readLock(Emp emp);

	public void writeLock(Emp emp);

	/**
	 * リスト9.3_2 「エンティティのプロパティを条件とする検索」のためのメソッド定義
	 */
	public List<Emp> findByExample(Emp emp);

}
