/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
//import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
//import javax.servlet.http.Part;

/**
 *
 * @author naoki
 */
//@MultipartConfig(maxFileSize=1024000)
public class FileReceiveServlet extends HttpServlet {
   
    /** 
     * Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        //request.setCharacterEncoding("UTF-8");
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            out.println("<h1>受け取り</h1>");

            String format = "%s:%s<br>%n";

            if(!DiskFileUpload.isMultipartContent(request)){
                out.println("ファイルアップロードではない");
                out.close();
                return;
            }
            DiskFileUpload fu = new DiskFileUpload();
            fu.setSizeMax(1024000);
            fu.setHeaderEncoding("UTF-8");

            List<FileItem> items = fu.parseRequest(request);
            for(FileItem item : items){
                out.printf(format, "フィールド名", item.getFieldName());
                if(item.isFormField()){
                    //通常のフィールド
                    out.printf(format, "内容", item.getString("UTF-8"));
                } else{
                    //ファイルのフィールド
                    out.printf(format, "ファイル名", item.getName());
                    out.printf(format, "サイズ", item.getSize());
                    item.delete();
                }
                out.println("<br>");
            }
        }catch(FileUploadException e){
            throw new ServletException(e);

/* Servlet3.0用
            for(Part item : request.getParts()){
                out.printf(format, "フィールド名", item.getName());
                if(item.getContentType() == null){
                    //通常のフィールド
                    //内容の取得
                    InputStream is = item.getInputStream();
                    Reader r = new InputStreamReader(is, "UTF-8");
                    BufferedReader bur = new BufferedReader(r);
                    String value = bur.readLine();
                    bur.close();
                    r.close();
                    is.close();
                    //表示
                    out.printf(format, "内容", value);
                }else{
                    //ファイルのフィールド
                    //ファイル名を取得
                    String disposition = item.getHeader("content-disposition");
                    String[] headers = disposition.split(";");
                    String filename = "";
                    for(String h : headers){
                        h = h.trim();
                        if(h.startsWith("filename=\"")){
                            filename = h.substring("filename=\"".length(), h.length() - 1);
                        }
                    }
                    //表示
                    out.printf(format, "disp", disposition);
                    out.printf(format, "ファイル名", filename);
                    out.printf(format, "サイズ", item.getSize());
                    item.delete();
                }
                out.println("<br>");
            }
*/
        } finally { 
            out.close();
        }
    } 

    // <editor-fold defaultstate="collapsed" desc="HttpServlet のメソッドです。コードを編集するには、左側の + 符号をクリックしてください。">
    /** 
     * Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    } 

    /** 
     * Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }

    /** 
     * Returns a short description of the servlet.
     * @return a String containing servlet description
     */
    @Override
    public String getServletInfo() {
        return "Short description";
    }// </editor-fold>

}
