/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * SynchronizeSample.java
 *
 * Created on 2009/07/27, 0:13:12
 */

package library;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JTextField;

/**
 *
 * @author naoki
 */
public class SynchronizeSample extends javax.swing.JFrame {

    ReentrantLock l = new ReentrantLock(true);
    class Train implements Runnable{

        String train;
        JTextField lane1;
        JTextField lane2;
        long speed;

        Train(String train, JTextField lane1, JTextField lane2, long speed){
            this.train = train;
            this.lane1 = lane1;
            this.lane2 = lane2;
            this.speed = speed;
        }

        public void run(){
            try {
                //橋の前
                print(lane2, "");
                for(String str = train; str.length() < 30; str = " " + str){
                    print(lane1, str);
                }
                //橋
                l.lock();
                try{
                    print(lane1, "");
                    for(String str = train; str.length() < 30; str = " " + str){
                        print(txtBridge, str);
                    }
                    print(txtBridge, "");
                }finally{
                    l.unlock();
                }
                //橋のあと
                for(String str = train; str.length() < 30; str = " " + str){
                    print(lane2, str);
                }
            } catch (InterruptedException ex) {
            }
        }

        /** テキストフィールドに文字列を表示 */
        void print(final JTextField field, final String str)
        throws InterruptedException{
            field.setText(str);
            Thread.sleep(speed);
        }
    }

    /** Creates new form SynchronizeSample */
    public SynchronizeSample() {
        initComponents();

        Runnable[] trains = {
            new Train("特急", txtExpressLane1, txtExpressLane2,  50),
            new Train("普通", txtNormalLane1,  txtNormalLane2,  100),
            new Train("急行", txtRapidLane1,   txtRapidLane2,    75)
        };

        ScheduledExecutorService ses =
                Executors.newScheduledThreadPool(trains.length);
        for(Runnable train : trains){
            ses.scheduleWithFixedDelay(train, 0, 1, TimeUnit.SECONDS);
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        txtExpressLane1 = new javax.swing.JTextField();
        txtNormalLane1 = new javax.swing.JTextField();
        txtRapidLane1 = new javax.swing.JTextField();
        txtBridge = new javax.swing.JTextField();
        txtExpressLane2 = new javax.swing.JTextField();
        txtNormalLane2 = new javax.swing.JTextField();
        txtRapidLane2 = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(txtRapidLane1, javax.swing.GroupLayout.DEFAULT_SIZE, 117, Short.MAX_VALUE)
                    .addComponent(txtNormalLane1)
                    .addComponent(txtExpressLane1))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(txtBridge, javax.swing.GroupLayout.PREFERRED_SIZE, 110, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(txtExpressLane2, javax.swing.GroupLayout.DEFAULT_SIZE, 135, Short.MAX_VALUE)
                    .addComponent(txtNormalLane2, javax.swing.GroupLayout.DEFAULT_SIZE, 135, Short.MAX_VALUE)
                    .addComponent(txtRapidLane2, javax.swing.GroupLayout.DEFAULT_SIZE, 135, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(txtExpressLane1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(txtExpressLane2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(txtNormalLane1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(txtBridge, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(txtNormalLane2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(txtRapidLane1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(txtRapidLane2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(221, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new SynchronizeSample().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField txtBridge;
    private javax.swing.JTextField txtExpressLane1;
    private javax.swing.JTextField txtExpressLane2;
    private javax.swing.JTextField txtNormalLane1;
    private javax.swing.JTextField txtNormalLane2;
    private javax.swing.JTextField txtRapidLane1;
    private javax.swing.JTextField txtRapidLane2;
    // End of variables declaration//GEN-END:variables

}
