/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * DateFormatSample.java
 *
 * Created on 2009/07/24, 4:03:05
 */

package library;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

/**
 *
 * @author naoki
 */
public class DateFormatSample extends javax.swing.JFrame {

    /** Creates new form DateFormatSample */
    public DateFormatSample() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        txtDate = new javax.swing.JTextField();
        btnShow = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        taOutput = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        btnShow.setText("表示");
        btnShow.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnShowActionPerformed(evt);
            }
        });

        taOutput.setColumns(20);
        taOutput.setRows(5);
        jScrollPane1.setViewportView(taOutput);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(txtDate, javax.swing.GroupLayout.DEFAULT_SIZE, 312, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnShow)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(txtDate, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnShow))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 253, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void btnShowActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnShowActionPerformed
        String str = txtDate.getText();
        try{
            DateFormat parser = DateFormat.getDateInstance();
            Date dt;
            dt = parser.parse(str);
            taOutput.append(String.format("%sは%tF %<tAです\n", str, dt));
            
            Calendar cal = Calendar.getInstance();
            cal.setTime(dt);
            taOutput.append(cal.get(Calendar.YEAR) + "年\n");
            taOutput.append(cal.get(Calendar.MONTH) + "番目の月\n");
            taOutput.append(cal.get(Calendar.DAY_OF_WEEK) + "番目の曜日\n");

            cal.add(Calendar.MONTH, 1);
            taOutput.append(String.format("一ヶ月後は%tF\n", cal.getTime()));
            cal.set(Calendar.DAY_OF_MONTH, 0);
            taOutput.append("入力月の最後の日は" + cal.get(Calendar.DATE) + "日\n");

            Locale l = new Locale("ja", "JP", "JP");
            Calendar jpCal = Calendar.getInstance(l);
            taOutput.append(jpCal.get(Calendar.ERA) + "番目の元号\n");
            taOutput.append(jpCal.get(Calendar.YEAR) + "年\n");
            SimpleDateFormat jpFormat = new SimpleDateFormat("Gy年 : GGGGy年", l);
            taOutput.append(jpFormat.format(dt));
        } catch(ParseException e){
            taOutput.append(str + "を日付として解釈できません\n");
        }
    }//GEN-LAST:event_btnShowActionPerformed

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new DateFormatSample().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnShow;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea taOutput;
    private javax.swing.JTextField txtDate;
    // End of variables declaration//GEN-END:variables

}
