/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ResourceSample.java
 *
 * Created on 2009/07/29, 6:28:59
 */

package io;

import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

/**
 *
 * @author naoki
 */
public class ResourceSample extends javax.swing.JFrame {

    /** Creates new form ResourceSample */
    public ResourceSample() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        btnShow = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        taOutput = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        btnShow.setText("表示");
        btnShow.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnShowActionPerformed(evt);
            }
        });

        taOutput.setColumns(20);
        taOutput.setRows(5);
        jScrollPane1.setViewportView(taOutput);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(153, 153, 153)
                        .addComponent(btnShow))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(btnShow)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 253, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void btnShowActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnShowActionPerformed
        Class c = getClass();
        InputStream is = c.getResourceAsStream("/io/Sample.properties");
        if(is == null){
            taOutput.append("ファイルが見つかりません\n");
            return;
        }
        Properties p = new Properties();
        try{
            p.load(is);
            is.close();
        } catch(IOException ex){
            ex.printStackTrace();
            return;
        }
        taOutput.append(p.getProperty("test") + "\n");
        taOutput.append(p.getProperty("try") + "\n");

        try{
            ResourceBundle rb = ResourceBundle.getBundle("io.Sample");
            taOutput.append(rb.getString("test") + "\n");
            taOutput.append(rb.getString("try") + "\n");
        } catch (MissingResourceException ex){
            taOutput.append("リソースバンドルが見つかりません\n");
        }

        Properties props = System.getProperties();
        taOutput.append(String.format("バージョン:%s\n",
                props.getProperty("java.version")));
        taOutput.append(String.format("OS:%s\n",
                props.getProperty("os.name")));
        taOutput.append(String.format("フォルダ区切り:%s\n",
                props.getProperty("file.separator")));
        taOutput.append(String.format("ユーザーディレクトリ:%s\n",
                props.getProperty("user.home")));
    }//GEN-LAST:event_btnShowActionPerformed

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new ResourceSample().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnShow;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea taOutput;
    // End of variables declaration//GEN-END:variables

}
