/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * JpaSample.java
 *
 * Created on 2009/08/03, 16:35:43
 */

package database;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import jpa.TBunrui;
import jpa.TShohin;

/**
 *
 * @author naoki
 */
public class JpaSample extends javax.swing.JFrame {

    /** Creates new form JpaSample */
    public JpaSample() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        txtSearch = new javax.swing.JTextField();
        btnList = new javax.swing.JButton();
        btnName = new javax.swing.JButton();
        btnCode = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        taOutput = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        btnList.setText("一覧");
        btnList.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnListActionPerformed(evt);
            }
        });

        btnName.setText("名前");
        btnName.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnNameActionPerformed(evt);
            }
        });

        btnCode.setText("コード");
        btnCode.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCodeActionPerformed(evt);
            }
        });

        taOutput.setColumns(20);
        taOutput.setRows(5);
        jScrollPane1.setViewportView(taOutput);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(txtSearch, javax.swing.GroupLayout.DEFAULT_SIZE, 182, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnList)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnName)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnCode)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(txtSearch, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnCode)
                    .addComponent(btnName)
                    .addComponent(btnList))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 253, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /* */
    private void btnListActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnListActionPerformed
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("guiPU");
        EntityManager em = emf.createEntityManager();

        Query q = em.createQuery("select s from TShohin s");
        List<TShohin> shohins = q.getResultList();
        for(TShohin s : shohins){
            TBunrui bunrui = s.getBunruiId();
            taOutput.append(String.format("%2d:%s(%s):%d%n",
                    s.getShohinId(),
                    s.getShohinName(),
                    (bunrui == null) ? "該当なし" : bunrui.getBunruiName(),
                    s.getPrice()));
        }

        em.close();
        emf.close();
    }//GEN-LAST:event_btnListActionPerformed

    /* */
    private void btnNameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnNameActionPerformed
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("guiPU");
        EntityManager em = emf.createEntityManager();

        Query q = em.createQuery("select s from TShohin s where s.shohinName = :n");
        String str = txtSearch.getText();
        q.setParameter("n", str);
        List<TShohin> shohins = q.getResultList();
        if(shohins.size() != 0){
            TShohin s = shohins.get(0);
            taOutput.append(String.format("%d:%s:%d円がみつかりました\n",
                    s.getShohinId(), s.getShohinName(), s.getPrice()));
        }else{
            taOutput.append(String.format("%sはみつかりませんでした\n",
                    str));
        }

        em.close();
        emf.close();
    }//GEN-LAST:event_btnNameActionPerformed

    /* */
    private void btnCodeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCodeActionPerformed
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("guiPU");
        EntityManager em = emf.createEntityManager();

        String str = txtSearch.getText();
        int id = Integer.parseInt(str);
        TShohin shohin = em.find(TShohin.class, id);
        if(shohin != null){
            taOutput.append(String.format("コード%dの商品は%sです\n",
                    id, shohin.getShohinName()));
        } else{
            taOutput.append(String.format("コード%dの商品はみつかりませんでした\n",
                    id));
        }

        em.close();
        emf.close();
    }//GEN-LAST:event_btnCodeActionPerformed

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new JpaSample().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCode;
    private javax.swing.JButton btnList;
    private javax.swing.JButton btnName;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea taOutput;
    private javax.swing.JTextField txtSearch;
    // End of variables declaration//GEN-END:variables

}
