/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ClassSample.java
 *
 * Created on 2009/07/14, 7:26:09
 */

package clazz;

import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

/**
 *
 * @author naoki
 */
public class ClassSample extends javax.swing.JFrame {

    /** Creates new form ClassSample */
    public ClassSample() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        btnShow = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        tpOutput = new javax.swing.JTextPane();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        btnShow.setText("表示");
        btnShow.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnShowActionPerformed(evt);
            }
        });

        jScrollPane1.setViewportView(tpOutput);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(162, 162, 162)
                        .addComponent(btnShow))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(btnShow)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 253, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /** メッセージを表示 */
    void putMessage(String str, SimpleAttributeSet attr){
        StyledDocument doc = tpOutput.getStyledDocument();
        try {
            doc.insertString(doc.getLength(), str, attr);
        } catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    /** 図形 */
    abstract class Figure{
        /** 幅 */
        private int width;
        /** 高さ */
        private int height;
        /** 高さの設定
         *@param height 高さ
         */
        public void setHeight(int height){
            this.height = height;
        }
        /** 高さの取得
         *@return 高さ
         */
        public int getHeight(){
            return height;
        }

        /** 幅と高さを指定してオブジェクトを生成する */
        public Figure(int width, int height) {
            this.width = width;
            this.height = height;
        }

        /** デフォルトの大きさでオブジェクトを生成する */
        Figure(){
            this(30, 30);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (getClass() != obj.getClass()) {
                return false;
            }
            final Figure other = (Figure) obj;
            if (this.width != other.width) {
                return false;
            }
            if (this.height != other.height) {
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 61 * hash + this.width;
            hash = 61 * hash + this.height;
            return hash;
        }

        @Override
        public String toString() {
            return "幅" + getWidth() + "高さ" + height + "の図形";
        }

        /** 情報を表示 */
        void information(){
            putMessage(toString() + "です\n", null);
        }

        /** 描画 */
        void draw(){
            Image img = createImage(getWidth(), getHeight());
            Graphics g = img.getGraphics();

            drawFigure(g);
            
            ImageIcon ii = new ImageIcon(img);
            SimpleAttributeSet attr = new SimpleAttributeSet();
            StyleConstants.setIcon(attr, ii);
            putMessage("\n", attr);
        }

        /** 描画の実装 */
        protected abstract void drawFigure(Graphics g);

        /**
         * @return the width
         */
        public int getWidth() {
            return width;
        }

        /**
         * @param width the width to set
         */
        public void setWidth(int width) {
            this.width = width;
        }
    }

    /** 四角 */
    class Rectangle extends Figure{
        Rectangle(int width, int height){
            super(width, height);
        }

        @Override
        protected void drawFigure(Graphics g){
            g.drawRect(0, 0, getWidth() - 1, getHeight() - 1);
        }
    }

    /** 面積を計算できる */
    interface Area{
        int getAreaSize();
    }

    /** 三角 */
    class Triangle extends Figure implements Area{//, Cloneable{

        public Triangle(int width, int height) {
            super(width, height);
        }

        Triangle(Triangle t){
            this(t.getWidth(), t.getHeight());
        }

        /*
        @Override
        protected Object clone() throws CloneNotSupportedException{
            return super.clone();
        }*/
        
        @Override
        protected void drawFigure(Graphics g) {
            g.drawLine(0,         getHeight() - 1, getWidth() / 2, 0);
            g.drawLine(getWidth() - 1, getHeight() - 1, getWidth() / 2, 0);
            g.drawLine(getWidth() - 1, getHeight() - 1, 0        , getHeight() - 1);
        }

        public int getAreaSize() {
            return getWidth() * getHeight() / 2;
        }

    }

    class Square extends Rectangle{
        Square() {
            super(30, 30);
        }
    }

    /** 表示ボタンが押されたときの処理 */
    private void btnShowActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnShowActionPerformed
        Figure[] figures = {
            new Triangle(52, 37), new Rectangle(62, 24), new Rectangle(84, 45)
        };
        for(Figure fig : figures){
            fig.information();
            fig.draw();
            if(fig instanceof Triangle){
                int s = ((Triangle)fig).getAreaSize();
                putMessage("面積は" + s + "です\n", null);
            }
        }

        /*
        Triangle copy;
        try {
            copy = (Triangle) tri.clone();
        } catch (CloneNotSupportedException ex) {b
            return;
        }*/
        Triangle tri = new Triangle(52, 37);

        Triangle copy = new Triangle(tri);
        copy.setWidth(20);
        putMessage("コピーは" + copy + "\n", null);
        copy.draw();
        putMessage(tri + "だよ\n", null);
        tri.draw();
        putMessage("面積は" + tri.getAreaSize() + "です\n", null);
        if(figures[0].equals(tri)){
            putMessage("1番目とtriは同じ\n", null);
        }
    }//GEN-LAST:event_btnShowActionPerformed

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new ClassSample().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnShow;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextPane tpOutput;
    // End of variables declaration//GEN-END:variables

}
