/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * StyleSample.java
 *
 * Created on 2009/07/09, 20:10:09
 */

package basic;

import java.awt.Color;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

/**
 *
 * @author naoki
 */
public class StyleSample extends javax.swing.JFrame {

    /** Creates new form StyleSample */
    public StyleSample() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        txtInput = new javax.swing.JTextField();
        btnNormal = new javax.swing.JButton();
        btnLarge = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        tpOutput = new javax.swing.JTextPane();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        btnNormal.setText("普通");
        btnNormal.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnNormalActionPerformed(evt);
            }
        });

        btnLarge.setText("大きい赤");
        btnLarge.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnLargeActionPerformed(evt);
            }
        });

        jScrollPane1.setViewportView(tpOutput);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(txtInput, javax.swing.GroupLayout.DEFAULT_SIZE, 230, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnNormal)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnLarge)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(txtInput, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnLarge)
                    .addComponent(btnNormal))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 253, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * 入力された文字列を出力する
     * @param attr
     */
    private void putMessage(SimpleAttributeSet attr) {
        //入力の取得
        String str = txtInput.getText();
        //出力
        StyledDocument doc = tpOutput.getStyledDocument();
        try {
            doc.insertString(doc.getLength(), str + "\n", attr);
        } catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    /** 「普通」ボタンの処理 */
    private void btnNormalActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnNormalActionPerformed
        //表示スタイルの設定
        SimpleAttributeSet attr = new SimpleAttributeSet();
        //出力
        putMessage(attr);
    }//GEN-LAST:event_btnNormalActionPerformed

    /** 「大きい赤」ボタンの処理 */
    private void btnLargeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnLargeActionPerformed
        //表示スタイルの設定
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setFontSize(attr, 20);
        StyleConstants.setForeground(attr, Color.RED);
        //出力
        putMessage(attr);
    }//GEN-LAST:event_btnLargeActionPerformed

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new StyleSample().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnLarge;
    private javax.swing.JButton btnNormal;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextPane tpOutput;
    private javax.swing.JTextField txtInput;
    // End of variables declaration//GEN-END:variables



}
